/* SCE CONFIDENTIAL
* PlayStation(R)3 Programmer Tool Runtime Library 430.001
* Copyright (C) 2012 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/

#ifndef _SCE_MATCHING_DEFINES_H_
#define _SCE_MATCHING_DEFINES_H_

#include <np.h>
#include "event.h"
#include <string>
#include <vector>

//e- Flags for Attribute Type
#define  SCE_TOOLKIT_NP_SESSION_SEARCH_ATTRIBUTE								(1<<1)  ///< This flag specifies that the session attribute is used as a search filter. 
#define  SCE_TOOLKIT_NP_SESSION_EXTERNAL_ATTRIBUTE								(1<<2)	///< This flag specifies that the session attribute is used as external session room data.
#define  SCE_TOOLKIT_NP_SESSION_INTERNAL_ATTRIBUTE								(1<<3)  ///< This flag specifies that the session attribute is used as internal session room data. 
#define  SCE_TOOLKIT_NP_SESSION_MEMBER_ATTRIBUTE								(1<<4)  ///< This flag specifies that the session attribute is used as session member data.
typedef  uint8_t SceToolkitNpSessionAttributeType ;

//e- Flags for Attribute Value Type
#define  SCE_TOOLKIT_NP_SESSION_ATTRIBUTE_VALUE_INT							(1<<1)	///< The value (<c>SessionAttributeValue</c>) of this attribute is an integer.
#define  SCE_TOOLKIT_NP_SESSION_ATTRIBUTE_VALUE_BINARY							(1<<2)  ///< The value (<c>SessionAttributeValue</c>) of this attribute is a binary value.
typedef  uint8_t SceToolkitNpSessionAttributeValueType ;

//e- Flags for Setting the size for Binary Attribute Value
#define	 SCE_TOOLKIT_NP_SESSION_ATTRIBUTE_MAX_SIZE_12							(1<<1)	///< The value (<c>SessionAttributeValue</c>) of this attribute is a binary value with a maximum size of 12 characters. 
#define	 SCE_TOOLKIT_NP_SESSION_ATTRIBUTE_MAX_SIZE_28							(1<<2)	///< The value (<c>SessionAttributeValue</c>) of this attribute is a binary value with a maximum size of 28 characters.
#define	 SCE_TOOLKIT_NP_SESSION_ATTRIBUTE_MAX_SIZE_60							(1<<3)  ///< The value (<c>SessionAttributeValue</c>) of this attribute is a binary value with a maximum size of 60 characters. 
#define	 SCE_TOOLKIT_NP_SESSION_ATTRIBUTE_MAX_SIZE_124							(1<<4)	///< The value (<c>SessionAttributeValue</c>) of this attribute is a binary value with a maximum size of 124 characters. 
#define	 SCE_TOOLKIT_NP_SESSION_ATTRIBUTE_MAX_SIZE_252							(1<<5)	///< The value (<c>SessionAttributeValue</c>) of this attribute is a binary value with a maximum size of 252 characters. 
typedef  uint8_t SceToolkitNpSessionAttributeMaxSize ;

//e-Search Flags. This flag is used to specify the Search Descriptor Flag
#define SCE_TOOLKIT_NP_SEARCH_FRIENDS_SESSIONS  								(1<<10) ///< This flag specifies that the search is for a friends session. 
#define SCE_TOOLKIT_NP_SEARCH_REGIONAL_SESSIONS 								(1<<12) ///< This flag specifies that the search is for a session that is hosted in your region. 
#define SCE_TOOLKIT_NP_SEARCH_RECENTLY_MET_SESSIONS							(1<<14) ///< This flag specifies that the search is for a session hosted by users in the Recently Met List.
typedef  uint32_t  SceToolkitNpSessionSearchFlag;

//e-Session Creation Flags. This flag is used to specify the Create Session Descriptor Flag
#define SCE_TOOLKIT_NP_CREATE_SESSION_TYPE_PUBLIC	 							(1<<2)	///< This flag specifies that all the slots in the session are available to the public.
#define SCE_TOOLKIT_NP_CREATE_SESSION_TYPE_PRIVATE	 							(1<<3)	///< This flag specifies that all the slots in the session are reserved for private players or friends. If this flag is set, then the session will not be visible to other users during searches.
typedef  uint16_t  SceToolkitNpSessionTypeFlag;

#define SCE_TOOLKIT_NP_CREATE_SIGNALING_MESH_SESSION							(1<<2)	///< This flag specifies that the session supports signaling.
#define SCE_TOOLKIT_NP_CREATE_PASSWORD_SESSION	 								(1<<4)	///< This flag specifies that the session is password protected. 
#define SCE_TOOLKIT_NP_CREATE_ALLOW_BLOCK_LIST_SESSION	 						(1<<5)	///< This flag specifies that the current session can be joined by a blocked user. This is not allowed by default.  
#define SCE_TOOLKIT_NP_CREATE_HOST_MIGRATION_SESSION	 						(1<<6)	///< This flag specifies that the session should be allowed to migrate when the owner quits. The ability to grant room ownership is not supported by default.
#define SCE_TOOLKIT_NP_CREATE_NAT_RESTRICTED_SESSION							(1<<7)	///< This flag specifies that users who cannot establish P2P connections are not allowed to join the session. 
typedef  uint16_t  SceToolkitNpSessionCreateFlag;

//e- Member Flags 
#define  SCE_TOOLKIT_NP_SESSION_MEMBER_OWNER	 								(1<<1)	///< This flag specifies that the current member is the session owner.
#define  SCE_TOOLKIT_NP_SESSION_MEMBER_MYSELF		 							(1<<2)	///< This flag specifies that the member is the user themselves (local).
typedef  uint8_t SceToolkitNpSessionMemberFlag ;

#define  SCE_TOOLKIT_NP_MAX_ATTRIBUTE_LENGTH									32		///< The maximum length of the session attribute.
#define  SCE_TOOLKIT_NP_MAX_ATTRIBUTES_IN_A_SESSION							64		///< The maximum number of attributes a session can have.
#define  SCE_TOOLKIT_NP_SESSION_NAME_MAX_SIZE									64		///< The maximum size of the session name.

#define  SCE_TOOLKIT_NP_ROOM_MESSAGE_RECEIVED	 								(1<<1)	///< This flag specifies that a room message was received.
#define  SCE_TOOLKIT_NP_ROOM_MESSAGE_SENT		 								(1<<2)	///< This flag specifies that a room message was sent. 
#define  SCE_TOOLKIT_NP_ROOM_MESSAGE_GENERAL		 							(1<<3)	///< This flag specifies that a message is a room message. 
#define  SCE_TOOLKIT_NP_ROOM_MESSAGE_CHAT		 								(1<<4)	///< This flag specifies that a message is a chat message. 
typedef  uint32_t SceToolkitNpRoomMessageFlag ;

#define  SCE_TOOLKIT_NP_ATTRIBUTE_MAX_BIN_VALUE								252		///< The maximum value of a binary attribute.

namespace sce { 
	namespace Toolkit {
		namespace NP {

	/// @brief
	/// Holds information about the slots present in a session. 
	///
	/// Holds information about the slots present in a session. 
	typedef struct SessionSlotsInfo
	{
		int16_t reservedSlots;			///< The number of slots that are reserved for a friend in a session.
		int16_t openSlots;				///< The number of slots that are open to the public.
	}SessionSlotsInfo;

	/// @brief
	/// Holds the value of a session attribute.
	///
	/// Holds the value of a session attribute.
	typedef union SessionAttributeValue
	{
		uint32_t attributeIntValue;									///< The integer value of a session attribute. 
		char attributeBinValue[SCE_TOOLKIT_NP_ATTRIBUTE_MAX_BIN_VALUE];	///< The binary data of a session attribute.
	}SessionAttributeValue;

	/// @brief
	/// A structure used to register session attributes. 
	///
	/// A structure used to register session attributes. 
	 typedef struct RegisterSessionAttribute
	{
		char attribute[SCE_TOOLKIT_NP_MAX_ATTRIBUTE_LENGTH];	///< The name of the session attribute.
		SceToolkitNpSessionAttributeType attributeType;			///< The type of the attribute. Use either #SCE_TOOLKIT_NP_SESSION_SEARCH_ATTRIBUTE, #SCE_TOOLKIT_NP_SESSION_EXTERNAL_ATTRIBUTE, #SCE_TOOLKIT_NP_SESSION_INTERNAL_ATTRIBUTE or #SCE_TOOLKIT_NP_SESSION_MEMBER_ATTRIBUTE.
		SceToolkitNpSessionAttributeValueType valueType;		///< The type of the value contained in the <c>SessionAttributeValue</c> object. Use <c>SCE_SESSION_ATTRIBUTE_VALUE_*</c> flags.
		SceToolkitNpSessionAttributeMaxSize maxSize;			///< The size of the binary data in the <c>SessionAttributeValue</c> object. Use <c>SCE_SESSION_ATTRIBUTE_MAX_SIZE_*</c> flags.					
		uint8_t padding;										///< Padding.	
	}RegisterSessionAttribute;

	 /// @brief
	 /// A structure used in a search request or when setting session attributes. 
	 ///
	 /// A structure used in a search request or when setting session attributes. 
	 typedef struct SessionRequestAttribute
	 {
		 char attribute[SCE_TOOLKIT_NP_MAX_ATTRIBUTE_LENGTH];	///< The name of the session attribute.
		 SessionAttributeValue attributeValue;				///< The value of the session attribute.
		 SceNpMatching2Operator searchOperator;				///< The search operator if the session attribute type is <c>SCE_SESSION_SEARCH_ATTRIBUTE_*</c>. This is used when filtering the sessions.
		 char padding[3];									///< Padding.
	 }SessionRequestAttribute;

	/// @brief
	/// Contains the information on a session attribute.
	///
	/// Contains the information on a session attribute.
	typedef struct SessionAttribute
	{
		char attribute[SCE_TOOLKIT_NP_MAX_ATTRIBUTE_LENGTH];	///< The name of the session attribute.
		SceToolkitNpSessionAttributeType attributeType;				///< The type of the attribute.
		SceNpMatching2Operator searchOperator;				///< The search operator if the session attribute type is <c>SCE_SESSION_SEARCH_ATTRIBUTE_*</c>. This is used when filtering the sessions.
		SceToolkitNpSessionAttributeMaxSize maxSize;					///< The size of the data in the <c>SessionAttributeValue</c> object.
		SceToolkitNpSessionAttributeValueType attributeValueType;	///< The type of value contained in the <c>SessionAttributeValue</c> object. Use <c>SCE_SESSION_ATTRIBUTE_VALUE_*</c> flags.
		SessionAttributeValue attributeValue;				///< The session attribute value.
	}SessionAttribute;

	/// @brief
	/// Holds an array of session attributes.
	/// 
	/// Holds an array of session attributes.
	typedef std::vector<SessionAttribute> SessionAttributeList;

	/// @brief
	/// Provides address information about the member. 
	///
	/// Provides address information about the member.
	typedef struct MemberAddress{
		struct in_addr addr;		///< The IP address.
		in_port_t port;				///< The port number.
	} MemberAddress;

	/// @brief
	/// Provides information about the member in a session. 
	///
	/// Provides information about the member in a session. 
	typedef struct SessionMember
	{
		/// @brief
		/// The default constructor.
		///
		/// The default constructor.
		SessionMember():memberId(0),natType(0),memberFlag(0)
		{
			memberAttributes.clear();
			memset(&userInfo,0,sizeof(userInfo));
			memset(&joinDate,0,sizeof(joinDate));
			memset(&memberConnInfo,0,sizeof(memberConnInfo));
		}
		SessionAttributeList memberAttributes;		///< The attributes related to the member.
		SceNpId userInfo;							///< The %NP ID information of the user.
		SceNpMatching2RoomMemberId memberId;		///< The room member ID of the member.
		SceNpMatching2NatType natType;				///< The member's NAT Type.
		SceToolkitNpSessionMemberFlag memberFlag;	///< Specifies whether this member is the owner, another member or the current user.
		CellRtcTick joinDate;						///< The date and time the user joined the session.
		MemberAddress  memberConnInfo;				///< The member's address.
	}SessionMember;

	/// @brief
	/// This structure contains information about session members. 
	///
	/// This structure contains information about session members.
	typedef std::vector<SessionMember> SessionMemberList;

	/// @brief
	/// This structure contains information about session events. 
	///
	/// This structure contains information about session events.
	typedef std::vector< SceNpMatching2Event > SessionEventList;

	/// @brief
	/// Contains information about a session. 
	///
	/// Contains information about a session. 
	typedef struct SessionInformation
	{
		/// @brief
		/// The default constructor.
		///
		/// The default constructor.
		SessionInformation():maxMembers(0),numMembers(0),
			numSessionAttributes(0),worldId(0),
			serverId(0),matchingContext(0),roomId(0)
		{
			memset(&sessionName,0,sizeof(sessionName));
			memset(&slotsInformation,0,sizeof(slotsInformation));
			sessionAttributes.clear();
			memberData.clear();
		}	
		char sessionName[SCE_TOOLKIT_NP_SESSION_NAME_MAX_SIZE];	///< The session name.
		int32_t maxMembers;										///< The maximum numbers of members in the session.
		int32_t numMembers;										///< The current number of members in the session.
		int32_t numSessionAttributes;							///< The number of attributes in the session. 
		SessionSlotsInfo slotsInformation;						///< Information about number of slots in the session open for public or private use.
		SceNpMatching2WorldId worldId;							///< The world ID for a session. 
		SceNpMatching2ServerId serverId;						///< The server ID for a session.
		SceNpMatching2ContextId matchingContext;				///< The Matching2 context ID. This should be used when using the %NP Matching2 library chat function to send messages to members in the current session.
		SceNpMatching2RoomId   roomId;							///< The ID of the current session.
		SessionAttributeList sessionAttributes;					///< The list of attributes for the session.
		SessionMemberList memberData;							///< Information about the members of the session. 
	}SessionInformation;

	/// @brief
	/// Contains the room ID and the request ID for message event. 
	///
	/// Contains the room ID and the request ID for message event.
	typedef union SessionEventId {
		SceNpMatching2RoomId           roomId;				///< The room ID for which the message was received. Retrieve this value if <c><i>msgFlag</i></c> is set to #SCE_TOOLKIT_NP_ROOM_MESSAGE_RECEIVED.
		SceNpMatching2RequestId		   requestId;			///< The request ID for which the message was sent. Retrieve this value if <c><i>msgFlag</i></c> is set to #SCE_TOOLKIT_NP_ROOM_MESSAGE_SENT.
	}SessionEventId;

	/// @brief
	/// Contains information about a type of room message event. 
	///
	/// Contains information about a type of room message event. 
	typedef struct SessionMessageEventType {
		SceToolkitNpRoomMessageFlag msgFlag;						///< A flag that specifies whether the room message was sent or received.
		SceNpMatching2RoomMemberId     srcMemberId;				///< The member ID of the room member whose message was received. This is available only when <c><i>msgFlag</i></c> is set to #SCE_TOOLKIT_NP_ROOM_MESSAGE_RECEIVED.
		uint8_t					padding[2];					///< Padding.
		SessionEventId				eventId;					///< The union for containing the room ID and the request ID.
	}SessionMessageEventType;


	/// @brief
	/// Session message callback. 
	///
	/// Session message callback.
	///
	/// @param ctxId				The matching context. 
	/// @param msgEvent				The message event type. 
	/// @param event				The matching 2 event
	/// @param data					The data received. 
	typedef void (*SessionMessageCallback)(
		SceNpMatching2ContextId        ctxId,				///< Matching Context.
		SessionMessageEventType        msgEvent,			///< Message Event Type.
		SceNpMatching2Event            event,				///< Matching 2 Event.
		const void *data);									///< Data received. 
	
	/// @brief
	/// Contains information about sessions. 
	///
	/// A list of sessions.
	typedef std::vector< SessionInformation > SessionList; 



	/// @brief
	/// Provides information to be displayed on the matching server for a session.
	///
	/// Provides information to be displayed on the matching server for a session.
	typedef struct CreateSessionRequest
	{
		char sessionName[SCE_TOOLKIT_NP_SESSION_NAME_MAX_SIZE];	///< The session name.
		SceToolkitNpSessionTypeFlag sessionTypeFlag;				///< The flag to specify whether the session is private or public. If no flag is specified, then the <c><i>slotsInformation</i></c> member needs to be provided. 
		SceToolkitNpSessionCreateFlag createSessionFlag;			///< The flags to specify type of session to create. Use OR if multiple flags are required.
		int32_t  maxSlots;										///< The maximum numbers of slots in a session. 
		SessionSlotsInfo slotsInformation;						///< The number of private and public players in a session. This information need not be set if <c><i>sessionTypeFlag</i></c> is set.
		char sessionPassword[SCE_NP_MATCHING2_SESSION_PASSWORD_SIZE];///< The password for the session. This member is only relevant when the #SCE_TOOLKIT_NP_CREATE_PASSWORD_SESSION flag is set. 
		SessionRequestAttribute *sessionAttributes;				///< A pointer to session attributes which needs to be set in the session.
		int32_t  numSessionAttributes;							///< The number of session attributes. 
		SceNpMatching2WorldId  worldId;							///< The world ID. Used to specify if there is a specific world in which to create the session. If the value is reset the session will be created in a random world.
		SceNpMatching2ServerId serverId;						///< The server ID. Used to specify if there is a specific server on which to create the session. If the value is reset an appropriate server is selected by the %NP %Toolkit library. 
		uint8_t padding[2];										///< Padding.
	}CreateSessionRequest;

	/// @brief
	/// A search descriptor to search for a session. 
	///
	/// A search descriptor to search for a session. 
	typedef struct SearchSessionsRequest
	{
		SceToolkitNpSessionSearchFlag searchFlags;			///< The flags to specify type of session to search for (<c>SCE_TOOLKIT_NP_SEARCH_*</c>).
		int32_t numSearchFilters;							///< The number of search filters in the search filter list. 
		SessionRequestAttribute *searchFilters;				///< The list of search filters. 
		SceNpId* friendsList;								///< The list of friends whose session is to be searched for. 
		int32_t numFriends;									///< The number of friends in the list of friends to search for. 
		SceNpMatching2WorldId worldId;						///< The world ID. Used to specify if there is a specific world in which to search for the session.
		SceNpMatching2ServerId serverId;					///< The server ID. Used to specify if there is a specific server on which to search for the session.
		uint8_t padding[2];									///< Padding.
	}SearchSessionsRequest;

	/// @brief
	/// The structure which needs to be passed in order to join a session. 
	///
	/// The structure which needs to be passed in order to join a session. 
	typedef struct JoinSessionRequest
	{
		SessionInformation* sessionInformation;				///< The information about the session that the sender of the request wishes to join.
		SceNpMatching2SessionPassword *sessionPassword;		///< The password for the session if it is password protected.
		SessionRequestAttribute *memberAttributes;			///< A pointer to the member attributes that needs to be set in the session.
		int32_t  numSessionAttributes;						///< The number of session attributes. 

	}JoinSessionRequest;
	
	/// @brief
	/// A structure used to specify attributes which needs to be modified. 
	///
	///A structure used to specify attributes which needs to be modified. 
	typedef struct  ModifySessionAttributes 
	{
		char attribute[SCE_TOOLKIT_NP_MAX_ATTRIBUTE_LENGTH];	///< The name of the session attribute.
		SessionAttributeValue attributeValue;				///<  The value of the session attribute.
	}ModifySessionAttributes;

	/// @brief
	/// A request structure used to specify how session information should be modified.
	///
	/// A request structure used to specify how session information should be modified.
	typedef struct ModifySessionRequest
	{
		ModifySessionAttributes *sessionAttributes;			///< The attributes to be modified. Only one type of attribute (<c>SCE_TOOLKIT_NP_SESSION_*_ATTRIBUTE</c>) can be specified.
		int32_t numAttributes;								///< The number of attributes to be modified.
		SceNpMatching2FlagAttr flagFilter;					///< Specifies the room flag filter which needs to be set. 
		SceNpMatching2FlagAttr flagAttr;					///< Specifies the room flag attribute which needs to be set. 
		SceToolkitNpSessionAttributeType attributeType;		///< The type of attribute. 
		uint8_t padding[3];								///< Padding.
	}ModifySessionRequest;

	/// @brief
	/// A request structure used to specify the session attributes to update.
	///
	/// A request structure used to specify the session attributes to update.
	typedef struct UpdateAttributeRequest
	{
		SceToolkitNpSessionAttributeType attributeType;				///< The type of attribute.
				SceNpMatching2RoomMemberId memberId;				///< The member ID.
		uint8_t padding[3];								///< Padding.
	}UpdateAttributeRequest;

		}//end NP
	}//end Toolkit
}//end sce
#endif
